/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.world.entity.ModEntityTypes;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.entity.ship.abilities.CannonBallEntity;
import com.talhanation.smallships.world.item.ModItems;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_7265;
import oshi.util.tuples.Pair;

public interface Cannonable
extends Ability {
    public CannonPosition getCannonPosition();

    public byte getMaxCannonCountRight();

    public byte getMaxCannonCountLeft();

    default public void tickCannonShip() {
        if (this.self().field_6012 % 2 == 0) {
            byte lc;
            byte rc = this.getCannonCooldownRight();
            if (rc > 0) {
                this.self().setData(Ship.CANNON_COOLDOWN_RIGHT, (byte)Math.max(rc - this.getCannonCountRight(), 0));
            }
            if ((lc = this.getCannonCooldownLeft()) > 0) {
                this.self().setData(Ship.CANNON_COOLDOWN_LEFT, (byte)Math.max(lc - this.getCannonCountLeft(), 0));
            }
        }
    }

    default public void defineCannonShipSynchedData() {
        this.self().method_5841().method_12784(Ship.CANNON_COUNT_RIGHT, (Object)0);
        this.self().method_5841().method_12784(Ship.CANNON_COUNT_LEFT, (Object)0);
        this.self().method_5841().method_12784(Ship.CANNON_COOLDOWN_RIGHT, (Object)0);
        this.self().method_5841().method_12784(Ship.CANNON_COOLDOWN_LEFT, (Object)0);
    }

    default public void readCannonShipSaveData(class_2487 tag) {
        class_2487 compoundTag = tag.method_10562("Cannon");
        class_2487 count = compoundTag.method_10562("Count");
        this.self().setData(Ship.CANNON_COUNT_RIGHT, count.method_10571("R"));
        this.self().setData(Ship.CANNON_COUNT_LEFT, count.method_10571("L"));
        class_2487 cooldown = tag.method_10562("Cooldown");
        this.self().setData(Ship.CANNON_COOLDOWN_RIGHT, cooldown.method_10571("R"));
        this.self().setData(Ship.CANNON_COOLDOWN_LEFT, cooldown.method_10571("L"));
    }

    default public void addCannonShipSaveData(class_2487 tag) {
        class_2487 compoundTag = new class_2487();
        class_2487 count = new class_2487();
        count.method_10567("R", this.self().getData(Ship.CANNON_COUNT_RIGHT).byteValue());
        count.method_10567("L", this.self().getData(Ship.CANNON_COUNT_LEFT).byteValue());
        class_2487 cooldown = new class_2487();
        cooldown.method_10567("R", this.self().getData(Ship.CANNON_COOLDOWN_RIGHT).byteValue());
        cooldown.method_10567("L", this.self().getData(Ship.CANNON_COOLDOWN_LEFT).byteValue());
        compoundTag.method_10566("Count", (class_2520)count);
        compoundTag.method_10566("Cooldown", (class_2520)cooldown);
        tag.method_10566("Cannon", (class_2520)compoundTag);
    }

    default public boolean interactCannon(class_1657 player, class_1268 interactionHand) {
        class_1799 item = player.method_5998(interactionHand);
        if (item.method_7909() == ModItems.CANNON) {
            Pair<class_243, Boolean> side = this.getSide((class_1309)player);
            if (!((Boolean)side.getB()).booleanValue()) {
                if (this.getCannonCountRight() >= this.getMaxCannonCountRight()) {
                    return false;
                }
                this.self().setData(Ship.CANNON_COUNT_RIGHT, (byte)(this.getCannonCountRight() + 1));
            } else {
                if (this.getCannonCountLeft() >= this.getMaxCannonCountLeft()) {
                    return false;
                }
                this.self().setData(Ship.CANNON_COUNT_LEFT, (byte)(this.getCannonCountLeft() + 1));
            }
            if (!player.method_7337()) {
                item.method_7934(1);
            }
            this.self().field_6002.method_43128(null, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), class_3417.field_15191, this.self().method_5634(), 15.0f, 1.5f);
            return true;
        }
        if (item.method_7909() instanceof class_1743) {
            Pair<class_243, Boolean> side = this.getSide((class_1309)player);
            if (!((Boolean)side.getB()).booleanValue()) {
                if (this.getCannonCountRight() <= 0) {
                    return false;
                }
                this.self().setData(Ship.CANNON_COUNT_RIGHT, (byte)(this.getCannonCountRight() - 1));
            } else {
                if (this.getCannonCountLeft() <= 0) {
                    return false;
                }
                this.self().setData(Ship.CANNON_COUNT_LEFT, (byte)(this.getCannonCountLeft() - 1));
            }
            this.self().method_5706((class_1935)ModItems.CANNON);
            this.self().field_6002.method_43128(null, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), class_3417.field_15191, this.self().method_5634(), 15.0f, 1.0f);
            return true;
        }
        return false;
    }

    default public double getCannonDamage() {
        return 4.0;
    }

    default public byte getCannonCountRight() {
        return this.self().getData(Ship.CANNON_COUNT_RIGHT);
    }

    default public byte getCannonCountLeft() {
        return this.self().getData(Ship.CANNON_COUNT_LEFT);
    }

    default public byte getCannonCooldownRight() {
        return this.self().getData(Ship.CANNON_COOLDOWN_RIGHT);
    }

    default public byte getCannonCooldownLeft() {
        return this.self().getData(Ship.CANNON_COOLDOWN_LEFT);
    }

    default public byte getCooldownTime() {
        return 50;
    }

    default public boolean canShoot() {
        AtomicBoolean isPresent = new AtomicBoolean(false);
        Ship ship = this.self();
        if (ship instanceof class_7265) {
            class_7265 containerEntity = (class_7265)ship;
            containerEntity.method_42278().stream().filter(itemStack -> itemStack.method_7909().equals(ModItems.CANNON_BALL)).findFirst().ifPresent(itemStack -> {
                itemStack.method_7934(1);
                isPresent.set(true);
            });
        } else {
            ship = this.self().method_5642();
            if (ship instanceof class_1657) {
                class_1657 player = (class_1657)ship;
                player.method_31548().field_7547.stream().filter(itemStack -> itemStack.method_7909().equals(ModItems.CANNON_BALL)).findFirst().ifPresent(itemStack -> {
                    itemStack.method_7934(1);
                    isPresent.set(true);
                });
            }
        }
        return isPresent.get();
    }

    default public void shoot(class_1309 shootingEntity) {
        Pair<class_243, Boolean> side = this.getSide(shootingEntity);
        if (((Boolean)side.getB() != false ? this.getCannonCooldownRight() : this.getCannonCooldownLeft()) > 0) {
            return;
        }
        if (((Boolean)side.getB() != false ? this.getCannonCountRight() : this.getCannonCountLeft()) <= 0) {
            return;
        }
        if (!this.canShoot()) {
            return;
        }
        double offset = -0.3f - ((float)((Boolean)side.getB() != false ? this.getCannonCountRight() : this.getCannonCountLeft()) - 1.0f) * 1.6f;
        float f0 = class_3532.method_15362((float)(this.self().method_36454() * ((float)Math.PI / 180))) * ((Boolean)side.getB() != false ? -1.0f : 1.0f);
        float f1 = class_3532.method_15374((float)(this.self().method_36454() * ((float)Math.PI / 180))) * ((Boolean)side.getB() != false ? -1.0f : 1.0f);
        class_243 forwardVec = this.self().method_5663().method_1029();
        double d = this.self().method_23317() - forwardVec.field_1352 * offset + (double)f0;
        double e = this.self().method_23318() - forwardVec.field_1351 + 1.0;
        double f = this.self().method_23321() - forwardVec.field_1350 * offset + (double)f1;
        CannonBallEntity cannonBall = new CannonBallEntity(ModEntityTypes.CANNON_BALL, d, e, f, shootingEntity.method_37908());
        cannonBall.method_7438(this.getCannonDamage());
        cannonBall.method_7432((class_1297)shootingEntity);
        class_243 vec = (class_243)side.getA();
        double angleY = shootingEntity.method_5720().field_1351;
        cannonBall.method_7485(vec.field_1352, vec.field_1351 + (angleY > 0.0 ? angleY * 0.75 : vec.field_1351 * 0.25), vec.field_1350, 3.0f, 1.0f);
        this.self().method_37908().method_43128(null, this.self().method_23317(), this.self().method_23318() + 4.0, this.self().method_23321(), ModSoundTypes.CANNON_SHOOT, class_3419.field_15248, 1.0f, 1.0f / (this.self().method_37908().method_8409().method_43057() * 0.4f + 1.2f) + 0.5f);
        this.self().method_37908().method_8649((class_1297)cannonBall);
        this.self().setData((Boolean)side.getB() != false ? Ship.CANNON_COOLDOWN_RIGHT : Ship.CANNON_COOLDOWN_LEFT, this.getCooldownTime());
        if (shootingEntity instanceof class_1657) {
            class_1657 player = (class_1657)shootingEntity;
            player.method_7259(class_3468.field_15372.method_14956((Object)ModItems.CANNON));
        }
    }

    default public Pair<class_243, Boolean> getSide(class_1309 entity) {
        class_243 forwardVec = this.self().method_5663().method_1029();
        class_243 rightVec = forwardVec.method_1024(-1.57f).method_1029();
        class_243 leftVec = forwardVec.method_1024(1.57f).method_1029();
        class_243 controllerVec = entity.method_5720().method_1029();
        if (controllerVec.method_1022(leftVec) > controllerVec.method_1022(rightVec)) {
            return new Pair((Object)rightVec, (Object)true);
        }
        return new Pair((Object)leftVec, (Object)false);
    }

    default public class_2960 getTextureLocation() {
        return new class_2960("smallships", "textures/entity/cannon/ship_cannon.png");
    }

    public static class CannonPosition {
        public final double offsetY;
        public final double offsetZ;
        public final float angle;

        public CannonPosition(double offsetY, double offsetZ, float angle) {
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.angle = angle;
        }
    }
}

